'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Config = undefined;

var _ui_setting_defaults = require('../../core_plugins/kibana/ui_setting_defaults');

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class Config {
  constructor(client, kibanaIndex) {
    this.kibanaIndex = kibanaIndex;
    this.config = (0, _ui_setting_defaults.getUiSettingDefaults)();
    _lodash2.default.forOwn(this.config, (val, key) => {
      this.config[key] = val.value;
    });

    this.client = client;
  }

  async init() {
    const response = await this.client('get', {
      index: this.kibanaIndex,
      type: '_all',
      id: 'config:siren'
    });

    const defaults = this.config;
    this.config = Object.assign(defaults, response._source.config);
  }

  get(str) {
    return this.config[str];
  }

  set(key, val) {
    this.config[key] = val;
  }
}
exports.Config = Config;
