'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Bool = undefined;

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

var _string = require('../../../ui/public/utils/lodash-mixins/string');

var _field_format = require('./field_format');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

(0, _string.lodashStringMixin)(_lodash2.default);

class Bool extends _field_format.FieldFormat {
  constructor(params) {
    super(params);
  }

  _convert(value) {
    if (typeof value === 'string') {
      value = value.trim().toLowerCase();
    }

    switch (value) {
      case false:
      case 0:
      case 'false':
      case 'no':
        return 'false';
      case true:
      case 1:
      case 'true':
      case 'yes':
        return 'true';
      default:
        return _lodash2.default.asPrettyString(value);
    }
  }
}

exports.Bool = Bool;
Bool.id = 'boolean';
Bool.title = 'Boolean';
Bool.fieldType = ['boolean', 'number', 'string'];
