'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bytesProvider = bytesProvider;

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

var _numeral = require('./_numeral');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function bytesProvider(config) {
  const Numeral = (0, _numeral.numeralProvider)(config);

  function bytes() {
    return Numeral.factory({
      id: 'bytes',
      title: 'Bytes',
      sampleInputs: [1024, 5150000, 1990000000]
    });
  }

  return bytes();
}
