'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Color = undefined;

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

var _string = require('../../../ui/public/utils/lodash-mixins/string');

var _field_format = require('./field_format');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

(0, _string.lodashStringMixin)(_lodash2.default);

const convertTemplate = _lodash2.default.template('<span style="<%- style %>"><%- val %></span>');
const DEFAULT_COLOR = {
  range: `${Number.NEGATIVE_INFINITY}:${Number.POSITIVE_INFINITY}`,
  regex: '<insert regex>',
  text: '#000000',
  background: '#ffffff'
};

class Color extends _field_format.FieldFormat {
  constructor(params) {
    super(params);
  }

  findColorRuleForVal(val) {
    switch (this.param('fieldType')) {
      case 'string':
        return _lodash2.default.findLast(this.param('colors'), colorParam => {
          return new RegExp(colorParam.regex).test(val);
        });

      case 'number':
        return _lodash2.default.findLast(this.param('colors'), ({ range }) => {
          if (!range) return;
          const [start, end] = range.split(':');
          return val >= Number(start) && val <= Number(end);
        });

      default:
        return null;
    }
  }
}

exports.Color = Color;
Color.id = 'color';
Color.title = 'Color';
Color.fieldType = ['number', 'string'];

Color.paramDefaults = {
  fieldType: null,
  colors: [_lodash2.default.cloneDeep(DEFAULT_COLOR)]
};

Color.prototype._convert = {
  html(val) {
    const color = this.findColorRuleForVal(val);
    if (!color) return _lodash2.default.escape(_lodash2.default.asPrettyString(val));

    let style = '';
    if (color.text) style += `color: ${color.text};`;
    if (color.background) style += `background-color: ${color.background};`;
    return convertTemplate({ val, style });
  }
};
