'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchConfigDefaults = fetchConfigDefaults;

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 *
 * @param  {Object} input
 * @param  {Object} config
 * @return {Object}
 */
function fetchConfigDefaults(input, config) {
  _lodash2.default.forOwn(input, (value, prop) => {
    if (!_lodash2.default.isString(value) || value.charAt(0) !== '=') {
      input[prop] = value;
      return;
    }

    const configKey = value.substr(1);

    input[prop] = config.get(configKey);
  });

  return input;
}
