'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TypeMap = undefined;

var _bytes = require('../types/bytes');

var _color = require('../types/color');

var _date = require('../types/date');

var _duration = require('../types/duration');

var _ip = require('../types/ip');

var _percent = require('../types/percent');

var _source = require('../types/source');

var _string = require('../types/string');

var _truncate = require('../types/truncate');

var _url = require('../types/url');

var _boolean = require('../types/boolean');

var _number = require('../types/number');

class TypeMap {
  constructor(config) {
    this._typeMap = {
      boolean: _boolean.Bool,
      bytes: (0, _bytes.bytesProvider)(config),
      color: _color.Color,
      date: (0, _date.dateProvider)(config),
      duration: _duration.Duration,
      ip: _ip.Ip,
      number: (0, _number.numberProvider)(config),
      percent: (0, _percent.percentProvider)(config),
      _source: _source.Source,
      string: _string._String,
      truncate: _truncate.Truncate,
      url: _url.Url
    };
  }

  /**
   * Returns the class for the supplied formatId
   * @param {string} formatId
   */
  getType(formatId) {
    return this._typeMap[formatId];
  }

  hasConverter(formatId) {
    return this._typeMap.hasOwnProperty(formatId);
  }
}
exports.TypeMap = TypeMap;
