'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _lodash = require('lodash');

exports.default = async (plugins, config) => {
  const path = [];
  let changeHandlerFunction;

  const waitUntilPluginReady = status => {
    return new Promise((resolve, reject) => {
      if (status.state === 'green') {
        resolve();
      }

      changeHandlerFunction = () => {
        if (status.state === 'green') {
          resolve();
        }
      };

      status.on('change', changeHandlerFunction);
    });
  };

  const initialize = async function (id, fn) {
    const plugin = plugins.byId[id];

    if ((0, _lodash.includes)(path, id)) {
      throw new Error(`circular dependencies found: "${path.concat(id).join(' -> ')}"`);
    }

    path.push(id);

    for (const reqId of plugin.requiredIds) {
      // when we are running './bin/investigate upgrade', we set enabled option of migrations plugin to false
      // so it should skip required plugins if plugin enabled option set to false
      if (config.get(reqId).enabled !== false) {
        if (!plugins.byId[reqId]) {
          throw new Error(`Unmet requirement "${reqId}" for plugin "${id}"`);
        }

        if (fn === 'init') {
          await initialize(reqId, fn);
          const status = plugins.byId[reqId].status;
          await waitUntilPluginReady(status);
          status.removeListener('change', changeHandlerFunction);
        } else {
          await initialize(reqId, fn);
        }
      }
    }

    await plugin[fn]();
    path.pop();
  };

  const collection = plugins.toArray();
  for (const _ref of collection) {
    const { id } = _ref;

    await initialize(id, 'preInit');
  }

  for (const _ref2 of collection) {
    const { id } = _ref2;

    await initialize(id, 'init');
  }
};

module.exports = exports['default'];
