'use strict';

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

var _bluebird = require('bluebird');

var _fs = require('fs');

var _path = require('path');

var _plugin_collection = require('./plugin_collection');

var _plugin_collection2 = _interopRequireDefault(_plugin_collection);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

module.exports = async (kbnServer, server, config) => {

  const plugins = kbnServer.plugins = new _plugin_collection2.default(kbnServer);

  const scanDirs = [].concat(config.get('plugins.scanDirs') || []);
  const pluginPaths = [].concat(config.get('plugins.paths') || []);

  const debug = _lodash2.default.bindKey(server, 'log', ['plugins', 'debug']);
  const warning = _lodash2.default.bindKey(server, 'log', ['plugins', 'warning']);

  // scan all scanDirs to find pluginPaths
  await (0, _bluebird.each)(scanDirs, async dir => {
    debug({ tmpl: 'Scanning `<%= dir %>` for plugins', dir: dir });

    let filenames = null;

    try {
      filenames = await (0, _bluebird.fromNode)(cb => (0, _fs.readdir)(dir, cb));
    } catch (err) {
      if (err.code !== 'ENOENT') throw err;

      filenames = [];
      warning({
        tmpl: '<%= err.code %>: Unable to scan non-existent directory for plugins "<%= dir %>"',
        err: err,
        dir: dir
      });
    }

    await (0, _bluebird.each)(filenames, async name => {
      if (name[0] === '.') return;

      const path = (0, _path.resolve)(dir, name);
      const stats = await (0, _bluebird.fromNode)(cb => (0, _fs.stat)(path, cb));
      if (stats.isDirectory()) {
        pluginPaths.push(path);
      }
    });
  });

  for (const path of pluginPaths) {
    let modulePath;
    try {
      modulePath = require.resolve(path);
    } catch (e) {
      warning({ tmpl: 'Skipping non-plugin directory at <%= path %>', path: path });
      continue;
    }

    await plugins.new(path);
    debug({ tmpl: 'Found plugin at <%= path %>', path: modulePath });
  }
};
