'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createIdQuery = createIdQuery;
/**
 * Finds a document by either its v5 or v6 format
 *
 * @param type The documents type
 * @param id The documents id or legacy id
**/
function createIdQuery({ type, id }) {
  const idForMigratedV5 = id.replace(`${type}:`, '');
  return {
    version: true,
    size: 1,
    query: {
      bool: {
        should: [
        // v5 document
        {
          bool: {
            must: [{ term: { _id: id } }, { term: { _type: type } }]
          }
        },
        // migrated v5 document
        {
          bool: {
            must: [{ term: { _id: `${type}:${idForMigratedV5}` } }, { term: { type: type } }]
          }
        },
        // v6 document
        {
          bool: {
            must: [{ term: { _id: id } }, { term: { type: type } }]
          }
        }]
      }
    }
  };
}
