'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.decorateEsError = decorateEsError;

var _elasticsearch = require('elasticsearch');

var _elasticsearch2 = _interopRequireDefault(_elasticsearch);

var _lodash = require('lodash');

var _errors = require('./errors');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const {
  ConnectionFault,
  ServiceUnavailable,
  NoConnections,
  RequestTimeout,
  Conflict,
  401: NotAuthorized,
  403: Forbidden,
  NotFound,
  BadRequest
} = _elasticsearch2.default.errors;

function decorateEsError(error) {
  if (!(error instanceof Error)) {
    throw new Error('Expected an instance of Error');
  }

  const { reason } = (0, _lodash.get)(error, 'body.error', {});
  if (error instanceof ConnectionFault || error instanceof ServiceUnavailable || error instanceof NoConnections || error instanceof RequestTimeout) {
    return (0, _errors.decorateEsUnavailableError)(error, reason);
  }

  if (error instanceof Conflict) {
    return (0, _errors.decorateConflictError)(error, reason);
  }

  if (error instanceof NotAuthorized) {
    return (0, _errors.decorateNotAuthorizedError)(error, reason);
  }

  if (error instanceof Forbidden) {
    return (0, _errors.decorateForbiddenError)(error, reason);
  }

  if (error instanceof NotFound) {
    return (0, _errors.decorateNotFoundError)(error, reason);
  }

  if (error instanceof BadRequest) {
    return (0, _errors.decorateBadRequestError)(error, reason);
  }

  return (0, _errors.decorateGeneralError)(error, reason);
}
