'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.normalizeEsDoc = normalizeEsDoc;

var _lodash = require('lodash');

var _saved_objects_client = require('../saved_objects_client');

function normalizeEsDoc(doc, overrides = {}) {
  if (!doc) return {};

  let type;
  const id = doc._id;
  let attributes;

  if (doc._type === _saved_objects_client.V6_TYPE) {
    type = overrides.type || (0, _lodash.get)(doc, '_source.type');
    attributes = (0, _lodash.get)(doc, `_source.${type}`) || overrides.attributes;
  } else {
    type = overrides.type || doc._type;
    attributes = doc._source;
  }

  return Object.assign({}, {
    id,
    type,
    version: doc._version,
    attributes
  }, overrides);
}
