'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createBulkCountRoute = undefined;

var _joi = require('joi');

var _joi2 = _interopRequireDefault(_joi);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const createBulkCountRoute = exports.createBulkCountRoute = prereqs => ({
  path: '/api/saved_objects/bulk_count',
  method: 'POST',
  config: {
    pre: [prereqs.getSavedObjectsClient],
    validate: {
      payload: _joi2.default.array().items(_joi2.default.object({
        type: _joi2.default.string().required()
      }).required())
    },
    handler(request, reply) {
      const { savedObjectsClient } = request.pre;

      reply(savedObjectsClient.bulkCount(request.payload, request)); // kibi: pass request to method
    }
  }
});
