'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _compatibility = require('./compatibility');

var _module_compatibility_service = require('./module_compatibility_service');

var _module_compatibility_service2 = _interopRequireDefault(_module_compatibility_service);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class ApiCompatibilityService {
  /**
   * @param  {FederateVersionParser} federateVersion
   */
  constructor(federateVersion) {
    this._compatibilityService = new _module_compatibility_service2.default(federateVersion, _compatibility.API_COMPATIBILITY_MATRIX);
  }

  /**
   * Check if API is available
   * @return {Boolean} True if api is available, otherwise False in case of unknown or disabled apis
   */
  isAvailable(apiKey) {
    return this._compatibilityService.isAvailable(apiKey);
  }
}exports.default = ApiCompatibilityService;
;
module.exports = exports['default'];
