'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.compatibilityResolverTests = undefined;

var _compatibility_status = require('../../utils/compatibility_status');

var _compatibility_status2 = _interopRequireDefault(_compatibility_status);

var _federate_version_parser = require('../../utils/federate_version_parser');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const getCompatibilityMatrix = function (versions) {
  versions = versions || [];
  return {
    min_supported: versions[0] || '5.6.10-10.1.1',
    feature_complete: versions[1] || '6.3.2-10.2.1',
    target: versions[2] || '6.7.2-10.3.0',
    toString: function () {
      return ` | Min: ${this.min_supported}, Feature Complete: ${this.feature_complete}, Target: ${this.target}`;
    }
  };
};

const wrapNodeVersions = function (nodeVersions) {
  return nodeVersions.map(version => {
    return {
      plugins: [{
        name: 'siren-federate',
        version
      }],
      toString: function () {
        return this.plugins[0].version;
      }
    };
  });
};

const compatibilityResolverTests = [{
  input: [wrapNodeVersions(['5.6.10-10.1.1', '6.3.2-10.2.1', '6.7.2-10.3.0']), getCompatibilityMatrix()],
  expected: {
    compatibility_status: _compatibility_status2.default.MIN_SUPPORTED
  }
}, {
  input: [wrapNodeVersions(['6.7.2-10.3.0', '6.3.2-10.2.1', '6.7.2-10.3.0']), getCompatibilityMatrix()],
  expected: {
    compatibility_status: _compatibility_status2.default.FEATURE_COMPLETE
  }
}, {
  input: [wrapNodeVersions(['6.7.2-10.3.0', '6.7.2-10.3.0', '6.7.2-10.3.0']), getCompatibilityMatrix()],
  expected: {
    compatibility_status: _compatibility_status2.default.TARGET
  }
}, {
  input: [wrapNodeVersions(['6.9.2-10.3.0', '6.9.2-10.3.0', '6.7.2-10.3.0']), getCompatibilityMatrix()],
  expected: {
    compatibility_status: _compatibility_status2.default.TARGET
  }
}, {
  input: [wrapNodeVersions(['5.5.10-10.1.1', '6.3.2-10.2.1', '6.7.2-10.3.0']), getCompatibilityMatrix()],
  expected: {
    compatibility_status: _compatibility_status2.default.TOO_OLD
  }
}, {
  input: [wrapNodeVersions(['5.5.10-10.1.1', '6.3.2-10.2.1', '7.0.0-10.3.0']), getCompatibilityMatrix()],
  expected: {
    compatibility_status: _compatibility_status2.default.TOO_HIGH
  }
}, {
  input: [wrapNodeVersions(['5.6.10-10.1.1', 'invalid-version', '6.0.0-10.3.0']), getCompatibilityMatrix()],
  expected: {
    compatibility_status: _compatibility_status2.default.INVALID_VERSION
  }
}, {
  input: [[{ plugins: [] }], getCompatibilityMatrix()],
  expected: {
    compatibility_status: _compatibility_status2.default.FEDERATE_NOT_FOUND
  }
}, {
  input: [wrapNodeVersions(['6.7.2-10.3.0', '6.7.2-10.3.0', '6.7.2-10.3.0']), getCompatibilityMatrix(['6.7.2-10.3.0', '6.7.2-10.3.0', '6.7.2-10.3.0'])],
  expected: {
    compatibility_status: _compatibility_status2.default.TARGET
  }
}, {
  input: [wrapNodeVersions(['6.7.2-10.3.0', '6.7.2-10.3.0', '6.7.2-10.3.0']), getCompatibilityMatrix(['6.3.2-10.3.0', '6.7.2-10.3.0', '6.7.2-10.3.0'])],
  expected: {
    compatibility_status: _compatibility_status2.default.TARGET
  }
}, {
  input: [wrapNodeVersions(['6.7.2-10.3.0', '6.7.2-10.3.0', '6.7.2-10.3.0']), getCompatibilityMatrix(['6.7.2-10.3.0', '6.7.2-10.3.0', '6.7.3-10.3.0'])],
  expected: {
    compatibility_status: _compatibility_status2.default.FEATURE_COMPLETE
  }
}];

exports.compatibilityResolverTests = compatibilityResolverTests;
