"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findPropertyInJson = findPropertyInJson;
exports.fixPropertyInJson = fixPropertyInJson;
// traverse JSON and look for a property with name "name"
// when found perform a test function
// return true if at least one valueTestFunction function returned true

function findPropertyInJson(json, keyName, testValueFunction) {
  const s = JSON.stringify(json);
  let found = false;
  JSON.parse(s, (key, value) => {
    if (key === keyName && testValueFunction(value)) {
      found = true;
    }
  });

  return found;
}

function fixPropertyInJson(json, keyName, fixValueFunction) {
  const s = JSON.stringify(json);
  return JSON.parse(s, (key, value) => {
    if (key === keyName) {
      return fixValueFunction(value);
    }
    return value;
  });
}
