import { each } from 'lodash';
import { EntityType } from 'ui/kibi/components/ontology/entity_type';

export function EntityModalsProvider(indexPatterns, savedSearches, confirmModal) {

  class EntityModals {

    deleteEntity(onConfirmFunction, modalTitle, modalText) {
      const confirmModalOptions = {
        messageAsHtml: 'true',
        title: modalTitle,
        confirmButtonText: 'Delete',
        cancelButtonText: 'Cancel',
        onConfirm: function () {
          onConfirmFunction();
        }
      };

      confirmModal(modalText, confirmModalOptions);
    }

    createNewChildSearchModal(onConfirmFunction, name) {
      const confirmModalOptions = {
        className: 'siren-saved-searches', // to be able to define styles in this component less
        title: 'Create new Child Search',
        confirmButtonText: 'Save',
        cancelButtonText: 'Cancel',
        messageAsHtml: 'true',
        beforeConfirm: (modalPopover) => {
          name = modalPopover.overlayElement.find('#save_saved_search_entity').val();
        },
        onConfirm: function () {
          onConfirmFunction(name);
        }
      };

      const modalText =
        `<div>
          <p>You are creating a search within <b>${name}</b>. You can open it from the side menu at any time.</p>
          <label>Please enter desired name below.</label></br>
          <input type="text" id="save_saved_search_entity" value="${name}"/></br>
        </div>`;

      confirmModal(modalText, confirmModalOptions);

    }

  }

  return new EntityModals();
}
