import '../styles/kibi_scripts.less';
import '../services/_saved_script';
import '../services/saved_scripts';
import 'ui/kibi/components/query_engine_client/query_engine_client';
import 'ace';
import 'angular-sanitize';
import uiRoutes from 'ui/routes';
import { uiModules } from 'ui/modules';
import template from '../index.html';

uiRoutes
  .when('/management/siren/scripts', {
    template,
    reloadOnSearch: false,
    resolve: {
      script: function (savedScripts) {
        return savedScripts.get();
      }
    }
  })
  .when('/management/siren/scripts/:id?', {
    template,
    reloadOnSearch: false,
    resolve: {
      script: function ($route, courier, savedScripts) {
        return savedScripts.get($route.current.params.id)
          .catch(courier.redirectWhenMissing({
            'script' : '/management/siren/scripts'
          }));
      }
    }
  });

function controller($routeParams, Promise, $scope, $route, kbnUrl, savedScripts, createNotifier, queryEngineClient, $element) {
  const notify = createNotifier({
    location: 'Scripts editor'
  });
  const script = $scope.script = $route.current.locals.script;

  $scope.isValid = function () {
    return $element.find('form[name="objectForm"]').hasClass('ng-valid');
  };

  $scope.newObject = function () {
    kbnUrl.change('/management/siren/scripts', {});
  };

  $scope.saveObject = function () {
    const _save = script.save();
    const _clearCache = _save.then(() => queryEngineClient.clearCache());

    return Promise.all([ _save, _clearCache ])
      .then(([ savedScriptId ]) => {
        notify.info(`Script ${script.title} successfully saved`);
        if (savedScriptId !== $routeParams.id) {
          kbnUrl.change('management/siren/scripts/{{id}}', { id: savedScriptId });
        }
      })
      .catch(notify.warning);
  };

  // expose some methods to the navbar buttons
  [ 'isValid', 'newObject', 'saveObject' ]
    .forEach(name => {
      $element.data(name, $scope[name]);
    });

  $scope.aceLoaded = function (editor) {
    editor.setOptions({
      minLines: 10
    });
  };
}

uiModules
  .get('apps/management', ['kibana', 'ui.ace', 'ngSanitize'])
  .controller('ScriptsEditor', controller);
