define(function (require) {
  const _ = require('lodash');

  require('ui/notify');

  const module = require('ui/modules').get('scripts_editor/services/saved_scripts', [
    'kibana/notify',
    'kibana/courier'
  ]);

  module.factory('SavedScript', function (courier) {
    _.class(SavedScript).inherits(courier.SavedObject);

    function SavedScript(id) {
      courier.SavedObject.call(this, {
        type: SavedScript.type,

        id: id,

        mapping: {
          title: 'string',
          description: 'string',
          scriptSource: 'string',
          type: 'string',
          version: 'integer'
        },

        defaults: {
          title: 'New Saved Script',
          description: '',
          scriptSource: '',
          type: '',
          version: 2
        },

        searchSource: true
      });
    }

    SavedScript.type = 'script';

    return SavedScript;
  });
});
