import 'plugins/investigate_core/saved_objects/dashboard_groups/saved_dashboard_groups';
import 'plugins/investigate_core/ui/directives/icon_picker';
import dashboardNavGroupEditorTemplate from './dashboard_nav_group_editor.html';
import { CacheProvider } from 'ui/kibi/helpers/cache_helper';
import './dashboard_nav_group_editor.less';
import { uiModules } from 'ui/modules';

uiModules
  .get('kibana')
  .directive('dashboardNavGroupEditor', ($rootScope, dashboardGroups,
    savedDashboardGroups, createNotifier, dashboardsNavState, Private) => {

    return {
      restrict: 'E',
      transclude: true,
      template: dashboardNavGroupEditorTemplate,
      link: function ($scope) {
        const cache = Private(CacheProvider);
        let notify = createNotifier({
          location: 'Dashboard Groups Editor'
        });
        $scope.dashboardGroup = {};

        $scope.setup = (id) => {
          savedDashboardGroups.get(id).then(newDashboardGroup => {
            $scope.dashboardGroup = newDashboardGroup;
            $scope.title = $scope.dashboardGroup.title;
          });
        };

        $scope.isGroupEditorOpen = () => {
          return dashboardsNavState.isGroupEditorOpen();
        };

        const setupGroupHandler = function (group) {
          $scope.setup(group.id);
        };

        dashboardGroups.on('groupSelected', setupGroupHandler);

        $scope.cancel = () => {
          $scope.setup();
          dashboardsNavState.setGroupEditorOpen(false);
        };

        $scope.save = () => {
          $scope.dashboardGroup.save().then((groupId) => {
            Promise.all([cache.invalidate]).then(() => {
              notify.info('Dashboard Group ' + $scope.dashboardGroup.title + ' was successfully saved');
              $scope.setup();
              dashboardsNavState.setGroupEditorOpen(false);
              $rootScope.$broadcast('kibi:dashboardgroup:changed', groupId);
            })
              .catch (notify.error);
          });
        };

        $scope.iconPickerCustomStyles = {
          left: '5px',
          width: '210px'
        };

        $scope.setup();

        $scope.$on('$destroy', function () {
          dashboardGroups.off('groupSelected', setupGroupHandler);
          notify = null; // this allow to completely garbage collect the object from memory
        });
      }
    };

  });
