import { each, filter } from 'lodash';
import { EntityType } from 'ui/kibi/components/ontology/entity_type';

export function validateRelation(
  relations, rel, typeMap, entityFieldTypeMap, typeErrorMessage,
  entityForm, virtualIndexMap, relationRangeFieldsTypeMap
) {
  let currentHash;
  if (typeMap[rel.domain.id] === EntityType.VIRTUAL_ENTITY) {
    currentHash = rel.domain.id + rel.range.id + rel.range.field;
  } else if (typeMap[rel.range.id] === EntityType.VIRTUAL_ENTITY) {
    currentHash = rel.domain.id + rel.domain.field + rel.range.id;
  } else {
    currentHash = rel.domain.id + rel.domain.field + rel.range.id + rel.range.field;
  }

  const currentHashKey = rel.$$hashKey;
  const foundEquivalent = filter(relations, r => {
    if (r.domain.id &&  r.range.field && r.range.id && r.domain.field) {
      const itemHash = r.domain.id +  r.range.field + r.range.id + r.domain.field;
      return itemHash === currentHash && currentHashKey !== r.$$hashKey;
    } else {
      return false;
    }
  });

  const foundDuplicate = filter(relations, r => {
    if (r.domain.id && r.range.id) {
      if (typeMap[rel.domain.id] === EntityType.VIRTUAL_ENTITY && r.range.field) {
        const itemHash = r.domain.id + r.range.id +  r.range.field;
        return itemHash === currentHash;
      } else if (typeMap[rel.range.id] === EntityType.VIRTUAL_ENTITY && r.domain.field) {
        const itemHash = r.domain.id + r.domain.field + r.range.id;
        return itemHash === currentHash;
      } else if (r.domain.field &&  r.range.field) {
        const itemHash = r.domain.id + r.domain.field + r.range.id +  r.range.field;
        return itemHash === currentHash;
      }
    }

    return false;
  });

  if (virtualIndexMap && virtualIndexMap.get(rel.domain.label) !== virtualIndexMap.get(rel.range.label)) {
    if (rel.domain.field && rel.range.field &&
      (entityFieldTypeMap.get(rel.domain.field) === 'keyword' || entityFieldTypeMap.get(rel.domain.field) === 'text' ||
      entityFieldTypeMap.get(rel.range.field) === 'keyword' || entityFieldTypeMap.get(rel.range.field) === 'text')) {
      rel.$$customError = 'Relations using string fields between an index from different datasources are not allowed at the moment';
      entityForm.$invalid = true;
    }
  }

  if (typeMap[rel.domain.id] === EntityType.SAVED_SEARCH &&
      rel.range.field &&
      entityFieldTypeMap && relationRangeFieldsTypeMap && relationRangeFieldsTypeMap.get(rel.id) &&
      entityFieldTypeMap.get(rel.domain.field) !== relationRangeFieldsTypeMap.get(rel.id).get(rel.range.field)
  ) {
    rel.$$customError = typeErrorMessage;
    entityForm.$invalid = true;
  }

  if (foundEquivalent.length > 0) {
    each(foundEquivalent, equivalent => {
      equivalent.$$customError = 'Equivalent relations - remove one';
    });
    entityForm.$invalid = true;
  }

  if (foundDuplicate.length > 1) {
    each(foundDuplicate, duplicate => {
      duplicate.$$customError = 'Duplicated relations - remove one';
    });
    entityForm.$invalid = true;
  }

};
