import { uiModules } from 'ui/modules';
import 'ui/directives/click_outside';
import angular from 'angular';
import _ from 'lodash';
import './siren_entity_select.less';
import entitySelectTemplate from './siren_entity_select.html';


uiModules.get('kibana')
  .directive('sirenEntitySelect', function ($timeout, $document) {

    return {
      template: entitySelectTemplate,
      restrict: 'E',
      scope: {
        selectedEntityId: '=',
        entities: '=',
        entityTypeToShow: '@', // SAVED_SEARCH/VIRTUAL_ENTITY/ALL
        onChange: '&',
        hideIndexPattern: '=?'
      },
      link($scope, $element, attrs) {
        $scope.showNav = false;
        const menuContainer = $element.find('.nav-container');

        function getEntityById(id) {
          if (id === undefined) {
            return '';
          }
          return _.find($scope.entities, 'id', id);
        }

        $scope.$watch('selectedEntityId', function (id) {
          if (id) {
            $scope.selectedEntity = getEntityById($scope.selectedEntityId);
          }
        });
        $scope.selectedEntity = getEntityById($scope.selectedEntityId);

        $scope.changeSelectedEntity = function (entity) {
          $scope.selectedEntityId = entity.id;
          $scope.selectedEntity = getEntityById(entity.id);
          $scope.showNav = false;
          // NOTE:
          // Propagate the change of selected entity up
          // In order to correctly pass the variable up to the function
          // it has to be in the form of object
          // { NAME_USED_IN_THE_UPPER_HTML_TEMPLATE: VALUE }
          // We are passing a copy of `selectedEntity` because otherwise when we change the field of the entity in one relation
          // it is changing field for another relation too
          $scope.onChange({ selectedRangeEntity: angular.copy($scope.selectedEntity) });
        };

        function enoughToExpandWidth(leftPosition, rightReservedPosition, elementWidth) {
          const clientWidth = document.documentElement.clientWidth;
          return clientWidth - leftPosition - elementWidth - rightReservedPosition >= 0;
        }

        function enoughToExpandHeight(topPosition, reservedBottomPosition, elementHeight) {
          const clientHeight = $document.find('.app-wrapper-panel').outerHeight();
          return clientHeight - topPosition - elementHeight - reservedBottomPosition >= 0;
        };

        function enoughToExpandHeightAbove(topInputPosition, reservedTopPosition, elementHeight) {
          return topInputPosition - reservedTopPosition - elementHeight >= 0;
        }

        function betterToShowAbove(topInputPosition, inputHeight, reservedTopPosition) {
          const MIN_MENU_HEIGHT = 110;
          const clientHeight = $document.find('.app-wrapper-panel').outerHeight();
          const availableSpaceAbove = topInputPosition - reservedTopPosition;
          const availableSpaceBelow = clientHeight - topInputPosition - inputHeight - reservedTopPosition;
          if (
            MIN_MENU_HEIGHT >= availableSpaceAbove
          || availableSpaceBelow >= MIN_MENU_HEIGHT
          ) {
            return false;
          } else {
            return true;
          };
        };

        function recalculateStylesForEntitiesMenu() {
          const RESERVED_POSITION = 15;
          const input = $element.find('.siren-entity-select');
          const navBar = $document.find('#kibi-global-nav');
          const inputPosition = input.offset();
          const inputHeight = input.height();
          const topElementPosition = inputPosition.top + inputHeight;
          const leftElementPosition = inputPosition.left - navBar.width();

          // remove applied styles before the next recalculating
          menuContainer.removeAttr('style');

          const menuContainerWidth = menuContainer.outerWidth();
          const menuContainerHeight = menuContainer.outerHeight();

          menuContainer
            .css('z-index', 999)
            .css('top', topElementPosition + 'px')
            .css('left', leftElementPosition + 'px');

          if (enoughToExpandWidth(leftElementPosition, RESERVED_POSITION, menuContainerWidth)) {
            menuContainer
              .css('width', menuContainerWidth + 'px');
          } else {
            menuContainer
              .css('width', 'unset')
              .css('right', RESERVED_POSITION + 'px');
          };
          if (enoughToExpandHeight(topElementPosition, RESERVED_POSITION, menuContainerHeight)) {
            menuContainer
              .css('height', menuContainerHeight + 'px');
          } else {
            if (betterToShowAbove(inputPosition.top, inputHeight, RESERVED_POSITION)) {
              const clientHeight = $document.find('.app-wrapper-panel').outerHeight();
              if (enoughToExpandHeightAbove(inputPosition.top, RESERVED_POSITION, menuContainerHeight)) {
                menuContainer
                  .css('top', 'unset')
                  .css('bottom', clientHeight - inputPosition.top + 'px');
              } else {
                menuContainer
                  .css('height', 'unset')
                  .css('top', RESERVED_POSITION + 'px')
                  .css('bottom', clientHeight - inputPosition.top + 'px');
              };
            } else {
              menuContainer
                .css('height', 'unset')
                .css('bottom', RESERVED_POSITION + 'px');
            }
          };
        };

        // watcher to recalculate position for dropdown menu if window's size is changed
        $scope.$watch(
          () => {
            const appWrapperPanel = $document.find('.app-wrapper-panel');
            const clientWidth = appWrapperPanel.outerWidth();
            const clientHeight = appWrapperPanel.outerHeight();
            const positionLeft = $element.offset().left;
            const positionRight = clientWidth - $element.outerWidth() - positionLeft;
            const positionTop = $element.offset().top;
            const positionBottom = clientHeight - $element.outerHeight() - positionTop;

            // return an unique value for position to recalculate styles on any position's change
            return positionLeft + ':' + positionTop + ':' + positionRight + ':' + positionBottom;
          },
          // $timeout to take correct position in Firefox
          () => $timeout(() => recalculateStylesForEntitiesMenu())
        );

        $scope.$watch('showNav', () => {
          const appWrapperElement = $document.find('.app-wrapper-panel');
          // append to top element to avoid overlap from any element of tree
          if ($scope.showNav) {
            menuContainer.appendTo(appWrapperElement);
            // init event from the next tick to don't react on current click
            $timeout(() => {
            // $scope.$id helps to create an unique id for an event
              $document.on('click.sirenEntitySelectClick' + $scope.$id, (event) => {
                event.stopPropagation();
                if (angular.element(event.target).closest('.nav-container')[0]) {
                  return;
                } else {
                  $scope.showNav = false;
                }
              });
            });
          } else {
          // return to directive if it is out of directive
            if (menuContainer.parent().prop('className') !== 'siren-entity-select') {
              menuContainer.appendTo($element.find('.siren-entity-select'));
              $document.off('.sirenEntitySelectClick' + $scope.$id);
            };
          };
        });

        $scope.$on('$destroy', () => {
          menuContainer.appendTo($element.find('.siren-entity-select'));
          $document.off('.sirenEntitySelectClick' + $scope.$id);
        });
      }
    };
  });
