'use strict';

const { internal } = require('boom');

module.exports = function (kibana) {
  return new kibana.Plugin({
    require: ['siren_federate'],
    id: 'jdbc_api',

    init: function (server) {
      server.route({
        method: 'GET',
        path: '/api/jdbc_api/virtual_indices/_count',
        handler: function (req, reply) {
          const query = {
            url: '/connector_elasticsearch/_siren/connector/index/_search',
            headers: {
              accept: 'application/json'
            }
          };
          if (server.plugins.investigate_access_control) {
            query.credentials = {
              backend: server.plugins.investigate_access_control.getBackendOption(),
              credentials: {
                username: server.config().get('elasticsearch.username'),
                password: server.config().get('elasticsearch.password')
              }
            };
          }

          server.inject(query).then(resp => {
            if (resp.statusCode === 200) {
              reply(JSON.parse(resp.payload).hits.total);
            } else {
              reply(internal(`Could not retrieve virtual indices (${resp.statusCode}):\n` + resp.payload));
            }
          }).catch(reply);
        }
      });
    }

  });
};
