'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _model = require('../model');

var _model2 = _interopRequireDefault(_model);

var _joi = require('joi');

var _joi2 = _interopRequireDefault(_joi);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Model for Eid objects.
 */
class EidModel extends _model2.default {

  constructor(server) {
    const schema = _joi2.default.object().keys({
      title: _joi2.default.string(),
      version: _joi2.default.number().integer(),
      siren: _joi2.default.object().keys({
        ui: _joi2.default.object().keys({
          icon: _joi2.default.string(),
          color: _joi2.default.string(),
          shortDescription: _joi2.default.string()
        })
      })
    });

    super(server, 'eid', schema, 'Eid');
  }

}
exports.default = EidModel;
module.exports = exports['default'];
