'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _joi = require('joi');

var _joi2 = _interopRequireDefault(_joi);

var _model = require('../model');

var _model2 = _interopRequireDefault(_model);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Model for mixed state data to be used in various contexts,
 * for when we just want to store some quick json with persistence.
 */
class MixedStateDocsModel extends _model2.default {

  constructor(server) {
    const schema = _joi2.default.object().keys({
      json: _joi2.default.string()
    });

    super(server, 'mixed-state-docs', schema, 'Mixed State Documents');
  }

}
exports.default = MixedStateDocsModel;
module.exports = exports['default'];
