'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _joi = require('joi');

var _joi2 = _interopRequireDefault(_joi);

var _model = require('../model');

var _model2 = _interopRequireDefault(_model);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Model for query objects.
 */
class QueryModel extends _model2.default {
  constructor(server) {

    const schema = _joi2.default.object().keys({
      title: _joi2.default.string(),
      description: _joi2.default.string().default(null),
      activationQuery: _joi2.default.string(),
      resultQuery: _joi2.default.string(),
      datasourceId: _joi2.default.string(),
      tags: _joi2.default.string(),
      rest_params: _joi2.default.object(),
      rest_headers: _joi2.default.object(),
      rest_variables: _joi2.default.object(),
      rest_body: _joi2.default.string(),
      rest_method: _joi2.default.string(),
      rest_path: _joi2.default.string(),
      rest_resp_status_code: _joi2.default.number(),
      activation_rules: _joi2.default.object(),
      version: _joi2.default.number().integer(),
      kibanaSavedObjectMeta: _joi2.default.object().keys({
        searchSourceJSON: _joi2.default.string()
      })
    });

    super(server, 'query', schema, 'Query');
  }
}
exports.default = QueryModel;
module.exports = exports['default'];
