'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _model = require('../model');

var _model2 = _interopRequireDefault(_model);

var _joi = require('joi');

var _joi2 = _interopRequireDefault(_joi);

var _search = require('./search');

var _search2 = _interopRequireDefault(_search);

var _eid = require('./eid');

var _eid2 = _interopRequireDefault(_eid);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function getSearchFor(type) {
  return {
    createFindQuery: () => {
      return {
        _source: type === 'search' ? 'search.kibanaSavedObjectMeta.searchSourceJSON' : false,
        query: {
          term: {
            type: type
          }
        }
      };
    }
  };
}

let searchModel;
let eidModel;

/**
 * Model for doc objects.
 */
class RelationModel extends _model2.default {

  constructor(server) {
    const schema = _joi2.default.object().keys({
      title: _joi2.default.string(),
      version: _joi2.default.number().integer(),
      domainId: _joi2.default.string(),
      domainField: _joi2.default.string(),
      rangeId: _joi2.default.string(),
      rangeField: _joi2.default.string(),
      directLabel: _joi2.default.string(),
      inverseLabel: _joi2.default.string(),
      inverseOf: _joi2.default.string(),
      timeout: _joi2.default.number().integer(),
      joinType: _joi2.default.string().allow(null)
    });

    searchModel = new _search2.default(server);
    eidModel = new _eid2.default(server);

    super(server, 'relation', schema, 'Relation');
  }

  async filterSearchResponse(request = {}, searchResponse, excludedIndices = [], ignoreBroken) {
    if (searchResponse && searchResponse.hits && searchResponse.hits.hits) {
      const searches = await searchModel.search(1000, getSearchFor('search'), request);
      const eids = await eidModel.search(1000, getSearchFor('eid'), request);
      const searchesSet = new Set();
      const eidSet = new Set();

      if (searches && searches.hits && searches.hits.hits) {
        for (const search of searches.hits.hits) {
          searchesSet.add(search._id);
        }
      }

      if (eids && eids.hits && eids.hits.hits) {
        for (const eid of eids.hits.hits) {
          eidSet.add(eid._id);
        }
      }

      const filteredRelations = [];
      for (const relation of searchResponse.hits.hits) {
        if (relation._source && relation._source.relation) {
          const domainId = relation._source.relation.domainId;
          const rangeId = relation._source.relation.rangeId;

          if (ignoreBroken || (searchesSet.has(domainId) || eidSet.has(domainId)) && (searchesSet.has(rangeId) || eidSet.has(rangeId))) {
            filteredRelations.push(relation);
          }
        }
      }

      searchResponse.hits.hits = filteredRelations;
      searchResponse.hits.total = filteredRelations.length;
    }

    return searchResponse;
  }

}
exports.default = RelationModel;
module.exports = exports['default'];
