'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _joi = require('joi');

var _joi2 = _interopRequireDefault(_joi);

var _model = require('../model');

var _model2 = _interopRequireDefault(_model);

var _indexpattern = require('./indexpattern');

var _indexpattern2 = _interopRequireDefault(_indexpattern);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

let indexPatternModel;

/**
 * Model for saved search objects.
 */
class SearchModel extends _model2.default {

  constructor(server) {
    const schema = _joi2.default.object().keys({
      title: _joi2.default.string(),
      description: _joi2.default.string(),
      hits: _joi2.default.number().integer(),
      columns: _joi2.default.string(),
      sort: _joi2.default.string(),
      version: _joi2.default.number().integer(),
      kibanaSavedObjectMeta: _joi2.default.object().keys({
        searchSourceJSON: _joi2.default.string()
      }),
      // kibi: additional properties
      siren: _joi2.default.object().keys({
        parentId: _joi2.default.string(),
        ui: _joi2.default.object().keys({
          icon: _joi2.default.string(),
          color: _joi2.default.string(),
          shortDescription: _joi2.default.string(),
          instanceLabelType: _joi2.default.string(),
          instanceLabelValue: _joi2.default.string()
        })
      })
    });

    indexPatternModel = new _indexpattern2.default(server);

    super(server, 'search', schema, 'Saved search');
  }

  async filterSearchResponse(request = {}, searchResponse, excludedIndices = [], ignoreBroken) {
    if (searchResponse && searchResponse.hits && searchResponse.hits.hits) {
      const indexPatterns = await indexPatternModel.search(1000, {
        createFindQuery: () => {
          return {
            _source: 'index-pattern.title',
            query: {
              term: {
                type: 'index-pattern'
              }
            }
          };
        }
      }, request);

      if (indexPatterns && indexPatterns.hits && indexPatterns.hits.hits) {
        const indexPatternsSet = new Set();
        for (const indexPattern of indexPatterns.hits.hits) {
          indexPatternsSet.add(indexPattern._id);
        }

        const filteredHits = [];

        for (const search of searchResponse.hits.hits) {
          const source = search._source.search;

          if (source && source.kibanaSavedObjectMeta && source.kibanaSavedObjectMeta.searchSourceJSON) {
            const searchSourceString = source.kibanaSavedObjectMeta.searchSourceJSON;

            const searchSource = JSON.parse(searchSourceString);

            if (searchSource.index && indexPatternsSet.has(searchSource.index)) {
              filteredHits.push(search);
            } else if (ignoreBroken && searchSource.index) {
              filteredHits.push(search);
            }
          }
        }

        searchResponse.hits.hits = filteredHits;
        searchResponse.hits.total = filteredHits.length;
      }
    }

    return searchResponse;
  }

}
exports.default = SearchModel;
module.exports = exports['default'];
