'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _base = require('./base');

var _base2 = _interopRequireDefault(_base);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Thrown when access to an object is not authorized.
 */
class AuthorizationError extends _base2.default {
  /**
   * Creates a new AuthorizationError.
   *
   * @param {string} message - The error message.
   * @param {Error} inner - An optional error that caused the AuthenticationError.
   */
  constructor(message, inner) {
    super(message, inner);
    this.name = 'AuthorizationError';
    this.status = 403;
    this.statusCode = 403;
  }
}
exports.default = AuthorizationError;
module.exports = exports['default'];
