import React from 'react';
import ReactDOM from 'react-dom';
import PropTypes from 'prop-types';
import {
  EuiButton,
  EuiButtonEmpty,
  EuiFieldText,
  EuiForm,
  EuiFormRow,
  EuiModal,
  EuiModalBody,
  EuiModalFooter,
  EuiModalHeader,
  EuiModalHeaderTitle,
  EuiOverlayMask,
} from '@elastic/eui';

import { EntityType } from 'ui/kibi/components/ontology/entity_type';
import { ObjectFinder } from 'ui/directives/saved_object_finder_component/object_finder_react';

export class OpenServices extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      savedObject: null,
      isModalVisible: true
    };
  }

  open = (savedObject) => {
    if (savedObject) {
      this.props.savedObjectService.get(savedObject.id)
        .then((savedObject) => {
          this.closeModal(savedObject);
        })
        .catch((error) => {
          this.props.notify.error(error);
          this.closeModal();
        });
    } else {
      this.closeModal();
    }
  };

  closeModal = (savedObject) => {
    this.setState({ isModalVisible: false });
    if (savedObject) {
      this.props.onConfirm(savedObject);
    } else {
      this.props.onCancel();
    }
    if (this.props.container) {
      ReactDOM.unmountComponentAtNode(this.props.container);
    }
  }

  render() {
    const loadForm = (
      <ObjectFinder
        service={this.props.savedObjectService}
        properties={ this.props.savedObjectService.loaderProperties }
        userOnChoose={this.open}
        type={this.props.savedObjectService.type}
        perPage={5}
        useLocalManagement={true}
      />
    );

    let modal;
    if (this.state.isModalVisible) {
      modal = (
        <EuiOverlayMask style="z-index:1000 !important;">
          <EuiModal
            onClose={ () => this.closeModal() }
          >
            <EuiModalHeader>
              <EuiModalHeaderTitle >
                { 'Load ' +  this.props.savedObjectService.type }
              </EuiModalHeaderTitle>
            </EuiModalHeader>

            <EuiModalBody>
              { loadForm }
            </EuiModalBody>

            <EuiModalFooter>
              <EuiButtonEmpty
                onClick={ () => this.closeModal() }
              >
                Cancel
              </EuiButtonEmpty>

            </EuiModalFooter>
          </EuiModal>
        </EuiOverlayMask>
      );
    }
    return (
      <React.Fragment>
        {modal}
      </React.Fragment>
    );
  }
}

OpenServices.propTypes = {
  savedObjectService: PropTypes.object.isRequired,
  notify: PropTypes.object,
  onConfirm: PropTypes.func.isRequired,
  onCancel: PropTypes.func.isRequired,
  container: PropTypes.object
};

export function openServices(savedObjectService, notify, onConfirm, onCancel) {
  const container = document.createElement('div');
  const element = (
    <OpenServices savedObjectService={savedObjectService}
      notify={notify}
      onConfirm={onConfirm}
      onCancel={onCancel}
      container={container}
    >
    </OpenServices>
  );
  ReactDOM.render(element, container);
}
