export function isMemoryAllocationError(error) {
  if (error.type === 'action_node_exception' && error.root_cause instanceof Array) {
    for (let i = 0; i < error.root_cause.length; i++) {
      const cause = error.root_cause[i];
      if (cause.type === 'buffer_allocator_exception' && cause.reason.indexOf('unable to allocate buffer of size') !== -1) {
        return true;
      }
    }
  }
  return false;
}

export function simplifyMemoryAllocationError(error) {
  const warning = 'Insufficient RAM available for this join. ' +
                  'Apply a filter on this (or the remote) dashboard to reduce memory requirements. ' +
                  'Alternatively review the cluster memory settings.';
  const err = new Error(warning + ' Details: ' + JSON.stringify(error));
  err.warning = warning;
  return err;
}


export function isIndexNotFoundError(error) {
  const errorText = JSON.stringify(error);
  return errorText.match(/index_not_found_exception/);
}

export function simplifyIndexNotFoundError(error) {
  error.warning = 'Index referred by this button does not exist.';
  return error;
}


export function isElasticsearchSecurityError(error) {
  const errorText = JSON.stringify(error);
  return errorText.match(/ElasticsearchSecurityException/);
}

export function simplifyElasticsearchSecurityError(error) {
  error.warning = 'Access to an index referred by this button is forbidden.';
  return error;
}


