'use strict';

var _session_ping_route = require('./session_ping_route');

/**
 * The siren_session plugin responsible for:
 * - injecting the cookie with sirenSID on the client side
 * - make sure the cookie is always recreated
 * - ping federate every minute to make sure the session is active
 * - injecting X-Federate-Session-Id into elasticsearch requests
 */
module.exports = function (kibana) {

  return new kibana.Plugin({
    require: ['elasticsearch'],
    id: 'siren_session',

    uiExports: {
      hacks: ['plugins/siren_session/ping']
    },

    init: function (server, options) {
      (0, _session_ping_route.addSessionPingRoute)(server);
    }
  });
};
