import uuid from 'uuid';
import chrome from 'ui/chrome';

const COOKIE_NAME = 'sirenSID';

function getCookie(name) {
  const value = '; ' + document.cookie;
  const parts = value.split('; ' + name + '=');
  if (parts.length === 2) {
    return parts.pop().split(';').shift();
  }
}

function setCookie(name, value, days) {
  let expires = '';
  if (days) {
    const date = new Date();
    date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
    expires = '; expires=' + date.toUTCString();
  }
  document.cookie = name + '=' + (value || '')  + expires + '; path=/';
}

function setupSirenSessionIdCookie() {
  if (!getCookie(COOKIE_NAME)) {
    setCookie(COOKIE_NAME, uuid.v1(), 365);
  }
}

export function setupSirenSessionCookie() {
  setupSirenSessionIdCookie();
  setInterval(function () {
    setupSirenSessionIdCookie();
  }, 5000);
}

export function sessionPing($http) {
  return $http.get(chrome.getBasePath() + '/session/ping');
}
