import { get, set } from 'lodash';
import unset from 'ui/kibi/lodash4/unset';

export function jobCancellation(chrome) {

  // We are rewriting the wrong header set by elasticsearch-browser angular client
  // This works as in webpackShims/elasticsearch-browser.js
  // we are explicitly telling the client to use angular http provider for all requests
  chrome.$setupJobCancallationRequestInterceptor = function ($httpProvider) {
    $httpProvider.interceptors.push(function () {
      return {
        request: function (opts) {
          const xOpaqueId = get(opts, ['headers', 'x-opaque-id']);
          if (xOpaqueId) {
            unset(opts, ['headers', 'x-opaque-id']);
            set(opts, ['headers', 'X-Opaque-Id'], xOpaqueId);
          }
          return opts;
        }
      };
    });
  };
}
