import _ from 'lodash';
import rison from 'rison-node';
import { keyMap } from 'ui/utils/key_map';
import { SavedObjectRegistryProvider } from 'ui/saved_objects/saved_object_registry';
import { uiModules } from 'ui/modules';
import { unmountComponentAtNode } from 'react-dom';

import './saved_object_finder_component/saved_object_finder.less';
import { objectFinder } from './saved_object_finder_component/object_finder_react';

const module = uiModules.get('kibana');

module.directive('savedObjectFinder', function ($location, kbnUrl, Private, config, savedSearches) {
  const services = Private(SavedObjectRegistryProvider).byLoaderPropertiesName;

  return {
    restrict: 'E',
    scope: {
      type: '@',
      // optional make-url attr, sets the userMakeUrl in our scope
      userMakeUrl: '=?makeUrl',
      // optional on-choose attr, sets the userOnChoose in our scope
      userOnChoose: '=?onChoose',
      // optional useLocalManagement attr,  removes link to management section
      useLocalManagement: '=?useLocalManagement',
      // kibi: optional needed for filtering visualizations based on dashboard savedSearchId
      savedSearchId: '=?savedSearchId',
      // kibi: allow to override the number of objects per page
      perPage: '=?perPage',
      /**
       * @type {function} - an optional function. If supplied an `Add new X` button is shown
       * and this function is called when clicked.
       */
      onAddNew: '='
    },
    controller: function ($scope, $element) {
      const self = this;

      // kibi: allow to override the number of objects per page
      if (!$scope.perPage) {
        // The number of items to show in the list
        $scope.perPage = config.get('savedObjects:perPage');
      }
      // kibi: end

      self.service = services[$scope.type];
      self.properties = self.service.loaderProperties;

      //kibi: set $scope.savedSearchTitle for displaying title instead of id
      function checkSavedSearchTitle() {
        if ($scope.savedSearchId) {
          return savedSearches.get($scope.savedSearchId);
        }
        return Promise.resolve("");
      };

      $scope.$on('$destroy', () => unmountComponentAtNode($element[0]));

      checkSavedSearchTitle()
        .then(savedSearch => {
          $scope.savedSearchTitle = savedSearch.title;
          objectFinder($element[0],
            self.service,
            self.properties,
            $scope.savedSearchId,
            $scope.savedSearchTitle,
            $scope.userMakeUrl,
            $scope.userOnChoose,
            $scope.type,
            $scope.perPage,
            $scope.onAddNew,
            $scope.useLocalManagement,
            kbnUrl,
            $location
          );
        });
    }
  };
});
