import { uiModules } from 'ui/modules';
import { forEach, mapKeys } from 'lodash';
import angular from 'angular';

uiModules
  .get('kibana')
  .directive('sirenScriptTranscluder', ($templateCache, $compile) => {
    return {
      restrict: 'E',
      scope: {
        template: '@',
        paramsValues: '=',
        modelData: '=',
        updateEvent: '&',
        getSelection: '&',
        loadItems: '&'
      },
      link: function (scope, element) {
        element.addClass('siren-script-transcluder');
        const template = $templateCache.get(scope.template);
        scope.params = scope.paramsValues;
        scope.data = scope.modelData;
        scope.update = scope.updateEvent;
        element.append($compile(template)(scope));
        if (scope.params.methods) {
          mapKeys(scope.params.methods, (func, name) => {
            scope.params.methods[name] = scope.params.methods[name].bind(scope);
          });
        }
        const inputs = element.find('input');
        forEach(inputs, input => {
          if (input.type.toLowerCase() === 'text') {
            angular.element(input).addClass('form-control');
          }
        });
        const buttons = element.find('button');
        forEach(buttons, button => angular.element(button).addClass('btn btn-basic'));
      }
    };
  });