export function addColumn(columns, columnName) {
  if (columns.includes(columnName)) {
    return;
  }

  columns.push(columnName);
}

export function removeColumn(columns, columnName) {
  if (!columns.includes(columnName)) {
    return;
  }

  columns.splice(columns.indexOf(columnName), 1);
}

export function moveColumn(columns, columnName, newIndex) {
  if (newIndex < 0) {
    return;
  }

  if (newIndex >= columns.length) {
    return;
  }

  if (!columns.includes(columnName)) {
    return;
  }

  columns.splice(columns.indexOf(columnName), 1);  // remove at old index
  columns.splice(newIndex, 0, columnName);  // insert before new index
}

export function moveColumnMinWidth(columns, columnName, newIndex, columnWidthArray) {
  const oldIndex = columns.indexOf(columnName);
  const removed = columnWidthArray.splice(oldIndex, 1);
  columnWidthArray.splice(newIndex, 0, removed);
};

export function moveNoWordWrap(columns, columnName, newIndex, customColumnWordWrap) {
  const oldIndex = columns.indexOf(columnName);
  const removed = customColumnWordWrap.splice(oldIndex, 1)[0];
  customColumnWordWrap.splice(newIndex, 0, removed);
};