import _ from 'lodash';
import { moveColumnMinWidth, moveNoWordWrap } from '../actions/columns';
import 'ui/filters/short_dots';
import './table_header.less';
import { onDashboardPage } from 'ui/kibi/utils/on_page';
import headerHtml from 'ui/doc_table/components/table_header.html';
// kibi: imports
import { getAlternativeSortingField } from 'ui/kibi/components/courier/data_source/get_alternative_sorting_field';
import './siren_sort_menu/siren_sort_menu';
// kibi: end
import { uiModules } from 'ui/modules';

const module = uiModules.get('app/discover');


module.directive('kbnTableHeader', function (shortDotsFilter, $timeout) {
  return {
    restrict: 'A',
    scope: {
      columns: '=',
      sortOrder: '=',
      indexPattern: '=',
      onChangeSortOrder: '=?',
      onRemoveColumn: '=?',
      onMoveColumn: '=?',
      // kibi: list of column aliases
      customColumnAliases: '=?',
      // kibi: list of no word wrap options
      customColumnWordWrap: '=?',
      // kibi: list of column min width
      customColumnMinWidth: '=?',
      // kibi: make time field column optional
      disableTimeField: '=?',
      // kibi: enable/disable row checkboxes for each row
      mfiltersEnabled: '=?',
      // kibi:show custom view or not
      showCustomView: '=?'
    },
    template: headerHtml,
    controller: function ($rootScope, $scope, $element, $location) {

      const isSortableColumn = function isSortableColumn(columnName) {
        // kibi: check if there is a valid alternative sorting field if the column is not sortable
        if (!!$scope.indexPattern && !!$scope.indexPattern.fields && _.isFunction($scope.onChangeSortOrder)) {
          const indexField = $scope.indexPattern.fields.byName ? $scope.indexPattern.fields.byName[columnName] : null;
          if (indexField) {
            if (indexField.sortable) {
              return true;
            }
            return !!getAlternativeSortingField($scope.indexPattern, indexField);
          }
        }
        return false;
        // kibi: end
      };

      // kibi: sort menu uses this function
      $scope.isSortableColumn = isSortableColumn;

      // kibi: display checkbox only in Dashboard page
      $scope.isDashboardPage = onDashboardPage();
      // kibi: end

      //kibi: these are required for fixed header in kibi enhanced table
      $element[0].querySelector('#fixed-header').style.display = 'none';
      const headerOffsets = [];

      //assign fixed header columns width from relative header
      const initialHeadersClientWidth = function () {
        headerOffsets.length = 0;
        const headers = $element[0].querySelector('#relative-header').cells;
        for (let i = 0; i < headers.length; i++) {
          const width = Math.round((headers[i].getBoundingClientRect().width) * 100) / 100;
          headerOffsets.push(width);
        }
      };

      //set fixed header position in table
      const alignFixedHeader = function (visWidth, visLeftOffset, parentLeftOffset) {
        const fixedHeader = $element[0].querySelector('#fixed-header');
        if (visWidth && visLeftOffset && parentLeftOffset) {
          fixedHeader.style.left = parentLeftOffset - visLeftOffset + 'px';
          fixedHeader.style.width = visWidth - parentLeftOffset + visLeftOffset - 14 + 'px';
        } else {
          fixedHeader.style.width = '95%';
          fixedHeader.style.left = '';
        }

        for (let i = 0; i < fixedHeader.cells.length; i++) {
          fixedHeader.cells[i].setAttribute('style','width: ' + headerOffsets[i] + 'px; min-width: ' + headerOffsets[i] + 'px;');
        }
      };

      $timeout(function () {
        initialHeadersClientWidth();
        alignFixedHeader();
      });

      //listen 'visResized' event from visualize.js and configure fixed header
      $scope.$on('visResized', function (event, visLeftOffset, visWidth, columns) {
        if (!_.isEqual(event.currentScope.columns, columns)) {
          return;
        }

        const parentLeftOffset = $element.parent().offset().left;
        initialHeadersClientWidth();
        alignFixedHeader(visWidth, visLeftOffset, parentLeftOffset);
      });

      //when user switch to standart template configure fixed header
      $scope.$watch('showCustomView', function (oldValue, newValue) {
        // kibi: don't run first load
        if (newValue === oldValue) {
          return;
        }
        initialHeadersClientWidth();
        alignFixedHeader();
      });

      //listen 'visScrolled' event from visualize.js and configure fixed header
      $scope.$on('visScrolled', function (event, visTopOffset, visLeftOffset, visWidth, columns) {
        if (!_.isEqual(event.currentScope.columns, columns) || $scope.showCustomView) {
          return;
        }

        // kibi: sort menu uses this value
        $scope.visTopOffset = visTopOffset;
        const elemTop =  $element.offset().top;
        const parentLeftOffset = $element.parent().offset().left;
        const fixedHeader = $element[0].querySelector('#fixed-header');
        const relativeHeader = $element[0].querySelector('#relative-header');
        const sortMenu = $element[0].querySelector('#siren-sort-menu');

        if (elemTop > visTopOffset) {
          fixedHeader.style.display = 'none';
          relativeHeader.style.visibility = '';
          if (sortMenu) sortMenu.style.marginTop = '0px';
        } else {
          relativeHeader.style.visibility = 'hidden';
          fixedHeader.style.position = 'absolute';
          fixedHeader.style.display = '';
          fixedHeader.style.top = '0px';
          fixedHeader.style.backgroundColor = 'white';
          fixedHeader.style.zIndex = '100';
          fixedHeader.style.overflow = 'hidden';
          fixedHeader.style.marginRight = '13px';
          if (sortMenu) sortMenu.style.marginTop = visTopOffset - elemTop + 'px';

          initialHeadersClientWidth();
          alignFixedHeader(visWidth, visLeftOffset, parentLeftOffset);
        }
      });
      //kibi: end

      $scope.tooltip = function (column) {
        if (!isSortableColumn(column)) return '';
        // kibi: use the column alias for the tooltip
        if ($scope.customColumnAliases && $scope.customColumnAliases.length) {
          const index = $scope.columns.indexOf(column);
          return 'Sort by ' + shortDotsFilter($scope.customColumnAliases[index]);
        }
        // kibi: end
        return 'Sort by ' + shortDotsFilter(column);
      };

      $scope.canMoveColumnLeft = function canMoveColumn(columnName) {
        return (
          _.isFunction($scope.onMoveColumn)
          && $scope.columns.indexOf(columnName) > 0
        );
      };

      $scope.canMoveColumnRight = function canMoveColumn(columnName) {
        return (
          _.isFunction($scope.onMoveColumn)
          && $scope.columns.indexOf(columnName) < $scope.columns.length - 1
        );
      };

      $scope.canRemoveColumn = function canRemoveColumn(columnName) {
        return (
          _.isFunction($scope.onRemoveColumn)
          && (columnName !== '_source' || $scope.columns.length > 1)
        );
      };

      $scope.headerClass = function (column) {
        if (!isSortableColumn(column)) return;

        const sortOrder = $scope.sortOrder;
        const defaultClass = ['fas', 'fa-sort', 'table-header-sortchange'];

        if (!sortOrder || column !== sortOrder[0]) return defaultClass;
        return ['fa', sortOrder[1] === 'asc' ? 'fa-sort-up' : 'fa-sort-down'];
      };

      $scope.moveColumnLeft = function moveLeft(columnName) {
        const newIndex = $scope.columns.indexOf(columnName) - 1;

        if (newIndex < 0) {
          return;
        }

        if ($scope.customColumnMinWidth) moveColumnMinWidth($scope.columns, columnName, newIndex,  $scope.customColumnMinWidth);
        if ($scope.customColumnMinWidth) moveNoWordWrap($scope.columns, columnName, newIndex, $scope.customColumnWordWrap);
        $scope.onMoveColumn(columnName, newIndex);
      };

      $scope.moveColumnRight = function moveRight(columnName) {
        const newIndex = $scope.columns.indexOf(columnName) + 1;

        if (newIndex >= $scope.columns.length) {
          return;
        }

        if ($scope.customColumnMinWidth) moveColumnMinWidth($scope.columns, columnName, newIndex,  $scope.customColumnMinWidth);
        if ($scope.customColumnMinWidth) moveNoWordWrap($scope.columns, columnName, newIndex, $scope.customColumnWordWrap);
        $scope.onMoveColumn(columnName, newIndex);
      };

      $scope.cycleSortOrder = function cycleSortOrder(columnName) {
        if (!isSortableColumn(columnName)) {
          return;
        }

        const [currentColumnName, currentDirection = 'asc'] = $scope.sortOrder;
        const newDirection = (
          (columnName === currentColumnName && currentDirection === 'asc')
            ? 'desc'
            : 'asc'
        );

        $scope.onChangeSortOrder(columnName, newDirection);
      };

      $scope.changeRowCheckboxesDisplay = function () {
        $scope.mfiltersEnabled.enabled = !$scope.mfiltersEnabled.enabled;
      };

      // kibi: added for sort menu
      $scope.sortMenuVisible = new Array($scope.columns.length + 1);
      _.fill($scope.sortMenuVisible, false);
      $scope.showSortMenu = function (index) {
        if (index === undefined) {
          index = $scope.columns.length;
        }
        const currentStatus = $scope.sortMenuVisible[index];
        _.fill($scope.sortMenuVisible, false);
        $scope.sortMenuVisible[index] =  !currentStatus;
        $timeout(() => {
          const sortMenu = $element[0].querySelector('#siren-sort-menu');
          if (sortMenu) {
            if ($element.offset().top > $scope.visTopOffset) {
              sortMenu.style.marginTop = '0px';
            } else {
              sortMenu.style.marginTop = $scope.visTopOffset -  $element.offset().top + 'px';
            }
          }
        }, 200);
      };
      // kibi: end
    }
  };
});
