import _ from 'lodash';
let excludedAttributes;
let comparators;

/**
 * Compare two filters to see if they match
 * @param {object} first The first filter to compare
 * @param {object} second The second filter to compare
 * @param {object} comparatorOptions Parameters to use for comparison
 * @returns {bool} Filters are the same
 */
export function compareFilters(first, second, comparatorOptions) {
  excludedAttributes = ['$$hashKey', 'meta'];
  comparators = _.defaults(comparatorOptions || {}, {
    state: false,
    negate: false,
    disabled: false,
  });

  if (!comparators.state) excludedAttributes.push('$state');

  return _.isEqual(mapFilter(first), mapFilter(second));
}

function mapFilter(filter) {
  const cleaned = _.omit(filter, excludedAttributes);
  // kibi: if _siren present in meta - use it
  if (filter.meta && filter.meta._siren &&
     filter.meta._siren.vis && filter.meta._siren.vis.id && filter.meta._siren.vis.panelIndex) {
    cleaned.visIdPanelIndexHash = filter.meta._siren.vis.id + filter.meta._siren.vis.panelIndex;
  }
  // kibi: end
  if (comparators.negate) cleaned.negate = filter.meta && !!filter.meta.negate;
  if (comparators.disabled) cleaned.disabled = filter.meta && !!filter.meta.disabled;
  return cleaned;
}
