import { getPhraseScript } from './phrase';
import { filterHelper } from 'ui/kibi/components/dashboards360/filter_helper';

export function buildPhrasesFilter(field, params, indexPattern, _siren) {
  const index = indexPattern.id;
  const type = 'phrases';
  const key = field.name;
  const value = params
    .map(value => field.format.convert(value))
    .join(', ');

  const filter = {
    meta: { index, type, key, value, params }
  };
  filterHelper.addSirenPropertyToFilterMeta(filter, _siren);

  let should;
  if (field.scripted) {
    should = params.map((value) => ({
      script: getPhraseScript(field, value)
    }));
  } else {
    should = params.map((value) => ({
      match_phrase: {
        [field.name]: value
      }
    }));
  }

  filter.query = {
    bool: {
      should,
      minimum_should_match: 1
    }
  };

  return filter;
}
