import { each, get } from 'lodash';
import { uiModules } from 'ui/modules';
import {
  findMainCoatNode,
  getCoatVisualizations,
  getCoatSearches,
  getParsedDecoratedCoat,
  checkTreeItems
} from 'ui/kibi/components/dashboards360/coat_tree';

function updateCoat(dash, visualizationIdTitleMap) {
  const parsedDecoratedCoat = getParsedDecoratedCoat(dash.coatJSON, dash.siren, visualizationIdTitleMap);
  if (!dash.siren) {
    dash.siren = {};
  }
  dash.siren.coat = parsedDecoratedCoat;
  const coatMainNode = findMainCoatNode(parsedDecoratedCoat.items);
  if (coatMainNode) {
    dash.siren.coatMainSearchId = coatMainNode.d.entity.id;
    dash.siren.coatMainNodeId = coatMainNode.id;
  }
  checkTreeItems(dash);
}
import 'ui/kibi/components/dashboards360/coat_panel_register';

uiModules
  .get('kibana')
  .service('coatDashboardMap', function (savedVisualizations, savedSearches, ontologyModel,
    indexPatterns, savedDashboards, coatPanelRegister, AppState, $route) {

  // TODO: refactor and move out of kibiState to shared small service !!!
  // can not require kibiState here due to circular dependency kibiState <- coatDashboardMap <- kibiState
  // these 2 functions are not really about kibiState and are used in many places
  // so there is a high chance some other place will encounter a circular dependency too
    function getDashboardOnView() {
      const dash = get($route, 'current.locals.dash');

      if (!dash || dash.locked) {
        return;
      }
      return dash;
    };

    function getCurrentDashboardId() {
      const dash = getDashboardOnView();

      if (dash) {
        return dash.id;
      } else {
      // try to get the dashboard id from the current params
        const params = get($route, 'current.params');
        if (params && params.id) {
          return params.id;
        }
        return;
      }
    };
    // end of TODO
    class CoatDashboardMap {

      constructor() {
        this.coatDashboardMap = new Map();
      }

      async updateCoatDashboardMapForDashboard(dash) {
        let panels;
        if (dash.siren && dash.siren.getPanels) {
          panels = dash.siren.getPanels();
        } else {
          panels = JSON.parse(dash.panelsJSON);
        }

        const coatVisualizationsPromise = getCoatVisualizations(savedVisualizations, savedSearches, panels);
        const relationsPromise = ontologyModel.getRelationList();
        const entitiesPromise = ontologyModel.getEntityList();
        const coatSearchesPromise = getCoatSearches(savedSearches, indexPatterns);
        const allSavedVisualizations = savedVisualizations.find();
        const visualizationIdTitleMap = new Map();

        return Promise.all([coatVisualizationsPromise, entitiesPromise, relationsPromise, coatSearchesPromise, allSavedVisualizations])
          .then(res => {
            dash.siren.visualizations = res[0];
            dash.siren.entities = res[1];
            dash.siren.relations = res[2];
            dash.siren.searches = res[3];
            each(res[4].hits, vis => {
              visualizationIdTitleMap.set(vis.id ,vis.title);
            });
          })
          .then(() => updateCoat(dash, visualizationIdTitleMap))
          .then(() => this.coatDashboardMap.set(dash.id, dash.siren.coat))
          .then(() => coatPanelRegister.triggerAll());
      }

      async updateCoatDashboardMap() {
        return savedDashboards.find()
          .then(resp => {
            const dashboards = resp.hits;
            const promises = [];
            each(dashboards, dash => {
              dash.siren = {
                entities: null, // TODO: rename with coat prefix
                relations: null,
                searches: null,

                // the below properties have to be reloaded
                visualizations: null, // when adding removing panels
                coat: null, // when saving dashboard
                coatMainSearchId: null, // when saving dashboard
                coatMainNodeId: null, // when saving dashboard
                // expose getPanels so for current dashboard we can return the correct panels even in edit mode
                // when dashboard was not yet saved
                appState: new AppState(),
                getPanels: function () {
                  if (dash.id === getCurrentDashboardId()) {
                    return this.appState.panels;
                  }
                  return JSON.parse(dash.panelsJSON);
                }
              };
              promises.push(this.updateCoatDashboardMapForDashboard(dash));
            });
            return Promise.all(promises);
          });
      }

      getCoatFromCoatDashboardMap(id) {
        return this.coatDashboardMap.get(id);
      }
    }
    return new CoatDashboardMap();
  });
