import { uiModules } from 'ui/modules';

uiModules
  .get('kibana')
  .service('coatPanelRegister', function () {

    class CoatPanelRegister {

      constructor() {
        this.register = [];
      }

      // f can return value or a promise
      add(f) {
        for (let i = 0; i < this.register.length; i++) {
          if (this.register[i] === f) {
            return;
          }
        }
        this.register.push(f);
      }

      remove(f) {
        for (let i = this.register.length - 1; i >= 0; i--) {
          if (f === this.register[i]) {
            this.register.splice(i, 1);
          }
        }
      }

      triggerAll() {
      // as f can return value or a promise
      // here we map it and retunr Promise.all
        return Promise.all(this.register.map(f => f()));
      }
    }
    return new CoatPanelRegister();
  });
