import { parseWithPrecision } from 'ui/kibi/utils/date_math_precision';

export function assignTimeFilters(treeItems, time, timefilter, sirenTimePrecision) {
  let t;
  if (time) {
    t = time;
  } else if (timefilter && timefilter.enabled === true) {
    t = timefilter.time;
  } else {
    return;
  }

  let gte;
  let lte;

  for (const item of treeItems) {
    if (item.type === 'node' &&
      item.d && item.d.entity &&
      item.d.entity.timeFieldName && item.d.entity.useGlobalTimeFilter
    ) {
      if (!item.d.entity.filters) {
        item.d.entity.filters = [];
      }
      if (!gte) {
        // compute values once per loop
        gte = parseWithPrecision(t.from, false, sirenTimePrecision).valueOf();
        lte = parseWithPrecision(t.to, true, sirenTimePrecision).valueOf();
      }

      const filter = {
        range : {
          [item.d.entity.timeFieldName]: {
            gte,
            lte,
            format: 'epoch_millis'
          }
        }
      };

      item.d.entity.filters.push(filter);

    } else if (item.type === 'node' &&
      item.d && item.d.entity &&
      item.d.entity.timeFieldName && !item.d.entity.useGlobalTimeFilter && item.d.range &&
      item.d.range.from && item.d.range.to) {
      if (!item.d.entity.filters) {
        item.d.entity.filters = [];
      }

      gte = parseWithPrecision(item.d.range.from, false, sirenTimePrecision).valueOf();
      lte = parseWithPrecision(item.d.range.to, true, sirenTimePrecision).valueOf();

      const filter = {
        range : {
          [item.d.entity.timeFieldName]: {
            gte,
            lte,
            format: 'epoch_millis'
          }
        }
      };

      item.d.entity.filters.push(filter);
    }
  }
}

