import { each, findIndex } from 'lodash';

export function removeMissingVisualizationsFromCoat(items, visualizations) {
  each(items, item => {
    if (item.d.widgets) {
      for (let i = item.d.widgets.length - 1; i >= 0; i--) {
        const index = findIndex(visualizations, 'id',  item.d.widgets[i].id);
        if (index < 0) {
          item.d.widgets.splice(i, 1);
        }
      }
    }
  });
}