import { cloneDeep } from 'lodash';
import { cleanFilter } from './clean_filter';
import { translateToQuery } from './translate_to_query';


// TODO: duplicated code from kibi_sequential_join_vis_helper.js
function _negateLastElementOfTheSequenceIfFilterWasNegated(joinSeqFilter) {
  if (joinSeqFilter.meta && joinSeqFilter.meta.negate === true) {
    joinSeqFilter.join_sequence[joinSeqFilter.join_sequence.length - 1].negate = true;
  }
}

// TODO: duplicated code from kibi_sequential_join_vis_helper.js
function composeGroupFromExistingJoinFilters(joinSeqFilters) {
  const groups = joinSeqFilters.map(f => {
    const joinSeqFiltersCloned = cloneDeep(f);
    _negateLastElementOfTheSequenceIfFilterWasNegated(joinSeqFiltersCloned);
    return joinSeqFiltersCloned.join_sequence;
  });
  return { group: groups };
};


function computeRelation(sourceField, sourceIndices, sourceFilters, targetField, targetIndices) {
  const relation = {
    relation: [
      {
        path: sourceField,
        indices: sourceIndices,
        queries: [
          {
            query: {
              bool: {
                must: []
              }
            }
          }
        ]
      },
      {
        path: targetField,
        indices: targetIndices
      }
    ]
  };
  sourceFilters.forEach(filter => {
    if (filter.meta && filter.meta.negate === true) {
      if (relation.relation[0].queries[0].query.bool.must_not === undefined) {
        relation.relation[0].queries[0].query.bool.must_not = [];
      }
      relation.relation[0].queries[0].query.bool.must_not.push(
        cleanFilter(translateToQuery(filter))
      );
    } else {
      relation.relation[0].queries[0].query.bool.must.push(
        cleanFilter(translateToQuery(filter))
      );
    }
  });

  return relation;
}

function computeSingleJoinFilter(sourceField, sourceIndices, sourceFilters, targetField, targetIndices) {
  // like jumping from source to target
  const relation = computeRelation(sourceField, sourceIndices, sourceFilters, targetField, targetIndices);
  const f = {
    join_sequence: [ relation ]
  };
  return f;
}


//      T
//      |
//      S

// Compute the join filter to be adde to target node T while traversing the tree bottom up
// Here it helps if you imagen beeing on "dash S" and do a single jump using relational navigator to "dash T"

// if source has no join filter
// create one join_sequence and add to target node filters

// if source has 1 join_sequence filter
// take this join sequence and add a new relation source->target and add it to target filters

// if source has multiple join filters
// create a join_sequence with a
//   - group from all existing join_seq filters and add this group at the top
//   - new relation from current dashboard to target dashboard

export function computeJoinFilter(sourceField, sourceIndices, sourceFilters, targetField, targetIndices) {
  const existingJoinSeqSourceFilters = sourceFilters.filter(filter => filter.join_sequence);
  const remainingSourceFilters = sourceFilters.filter(filter => !filter.join_sequence);

  let joinFilter;
  if (existingJoinSeqSourceFilters.length === 0) {
    joinFilter = computeSingleJoinFilter(sourceField, sourceIndices, remainingSourceFilters, targetField, targetIndices);
  } else if (existingJoinSeqSourceFilters.length === 1) {
    joinFilter = cloneDeep(existingJoinSeqSourceFilters[0]); // we have to clone it to avoid modyfication of sourceNode
    const relation = computeRelation(sourceField, sourceIndices, remainingSourceFilters, targetField, targetIndices);
    joinFilter.join_sequence.push(relation);
  } else {
    joinFilter = computeSingleJoinFilter(sourceField, sourceIndices, remainingSourceFilters, targetField, targetIndices);
    const group = composeGroupFromExistingJoinFilters(existingJoinSeqSourceFilters);
    joinFilter.join_sequence.unshift(group);
  }
  return joinFilter;
}
