import { cloneDeep, get, find } from 'lodash';
import { findItemByVisIdAndPanelIndex } from '../coat/find_item_by_vis_id_and_panel_index';
import { translateToQuery } from '../translate_to_query';
import { findMainNode } from '../find_main_node';
import { computeFocusedNodeFilters } from './compute_focused_node_filters';


export function composeJoinFilterForForeignVis({
  _sirenFromVis, allFilters = [], time,
  timefilter, sirenTimePrecision, useRootNodeAsFocus = false
}) {

  const filters = allFilters.map(filter => {
    return cloneDeep(translateToQuery(filter));
  });

  if (!get(_sirenFromVis, 'coat.items')) {
    throw new Error('Can not compute linked visualization join filter. Some parameters are missing on vis');
  }

  if (useRootNodeAsFocus === false) {
    if (!(get(_sirenFromVis, 'vis.id') && get(_sirenFromVis, 'vis.panelIndex'))) {
      throw new Error('Can not compute linked visualization join filter. Some parameters are missing on vis');
    }
  }

  const joinAlgorithmType = _sirenFromVis.coat.joinAlgorithmType;
  const coatItems = _sirenFromVis.coat.items;
  const mainNode = findMainNode(coatItems);
  // We should always be identifying nodes in COAT by combination of vis.id + vis.panelIndex
  // Why?
  // only this combination allows to uniquly identify the visualisation
  // note that user can place the same visualisation multiple times on a single dashboard
  let focusedNode;
  if (useRootNodeAsFocus === false) {
    const visId = _sirenFromVis.vis.id;
    const panelIndex = _sirenFromVis.vis.panelIndex;
    focusedNode = findItemByVisIdAndPanelIndex(coatItems, visId, panelIndex);
    if (!focusedNode) {
      throw new Error('Could not find focused node while computing linked visualization join filter for vis: ' + visId);
    }
  } else {
    focusedNode = mainNode;
  }

  const allNodeFilters = computeFocusedNodeFilters(
    coatItems, focusedNode.id, filters, time, timefilter, sirenTimePrecision, joinAlgorithmType
  );
  return allNodeFilters.filter(f => f.join_sequence);
}
