import { cloneDeep } from 'lodash';
import { assignTimeFilters } from '../assign_time_filters';
import { rotateTree } from '../rotate_tree';
import { addDepths } from '../add_depths';
import { computeFilters } from '../compute_filters';
import { findItemById } from '../find_item_by_id';
import { cleanFilter } from '../clean_filter';
import { JoinAlgorithmType } from '../join_algorithm_type';
import { pruneNotFoundItems } from '../prune_not_found_items';

import { assignFiltersToCoat } from '../assign_filters_to_coat';

export function computeFocusedNodeFilters(coatItems, focusNodeId, filters, time, timefilter, sirenTimePrecision, joinAlgorithmType) {
  // we clone the items before assigning any filters to avoid poluting the original coat tree
  let focusedTree = cloneDeep(coatItems);

  // 1) prune nodes and liks for which we detected any problem (notFound = true)
  // 2) assign all filters to correct nodes
  // 3) assign time filters
  // 4) rotate - mind that rotaion is changing links direction
  // 5) compute the focused node filters
  // 6) return focus node filters

  focusedTree = pruneNotFoundItems(focusedTree);
  assignFiltersToCoat(focusedTree, filters);
  assignTimeFilters(focusedTree, time, timefilter, sirenTimePrecision);
  focusedTree = rotateTree(focusedTree, focusNodeId);
  addDepths(focusedTree);
  computeFilters(focusedTree, joinAlgorithmType || JoinAlgorithmType.INNER_FILTER_JOIN);
  // at the end the focused node of focusedTree should have final set of filters
  // we have to find it as we cloned all nodes during tree rotation
  const focusedTreeFocusedNode = findItemById(focusedTree, focusNodeId);
  if (!focusedTreeFocusedNode.d.entity.filters) {
    return [];
  }
  return focusedTreeFocusedNode.d.entity.filters.map(filter => cleanFilter(filter));
}
