import { EntityType } from 'ui/kibi/components/ontology/entity_type';
import { findItemByVisIdAndPanelIndex } from '../coat/find_item_by_vis_id_and_panel_index';

export function getSearchIdFromFilter(items, filter) {
  if (!(filter.meta && filter.meta._siren && filter.meta._siren.vis && filter.meta._siren.vis.id && filter.meta._siren.vis.panelIndex)) {
    return null;
  }
  const nodeFromFilter = findItemByVisIdAndPanelIndex(items, filter.meta._siren.vis.id, filter.meta._siren.vis.panelIndex);
  if (!(nodeFromFilter && nodeFromFilter.d && nodeFromFilter.d.entity) || nodeFromFilter.d.entity.type !== EntityType.SAVED_SEARCH) {
    return null;
  }
  return nodeFromFilter.d.entity.id;
}
