import { findItemById } from '../find_item_by_id';
import { parseWithPrecision } from 'ui/kibi/utils/date_math_precision';

export function getTimeFilter({
  _sirenFromVis,
  timefilter,
  sirenTimePrecision
}) {
  if (!timefilter || timefilter.enabled !== true) {
    return null;
  }
  if (!_sirenFromVis || !_sirenFromVis.coat || !_sirenFromVis.coat.items || !_sirenFromVis.coat.node || !_sirenFromVis.coat.node.id) {
    return null;
  }

  const item = findItemById(_sirenFromVis.coat.items, _sirenFromVis.coat.node.id);

  if (item.type === 'node' &&
    item.d && item.d.entity &&
    item.d.entity.timeFieldName && item.d.entity.useGlobalTimeFilter
  ) {
    const t = timefilter.time;
    const gte = parseWithPrecision(t.from, false, sirenTimePrecision).valueOf();
    const lte = parseWithPrecision(t.to, true, sirenTimePrecision).valueOf();

    const filter = {
      range : {
        [item.d.entity.timeFieldName]: {
          gte,
          lte,
          format: 'epoch_millis'
        }
      }
    };
    return filter;
  }
  return null;
}
