import chrome from 'ui/chrome';
import angular from 'angular';
import _ from 'lodash';
import { uiModules } from 'ui/modules';

uiModules
  .get('kibana/query_engine_client')
  .service('queryEngineClient', function ($http) {

    function QueryEngineClient() {}

    QueryEngineClient.prototype._makeRequestToServer = function (url, queryDefs, options) {
      options = options || {};
      options.selectedDocuments = _.compact(options.selectedDocuments);

      if (queryDefs && !(queryDefs instanceof Array) && typeof queryDefs === 'object') {
        queryDefs = [queryDefs];
      }

      const params = {
        options: angular.toJson(options),
        queryDefs: angular.toJson(queryDefs)
      };

      return $http.get(chrome.getBasePath() + url, { params: params });
    };

    QueryEngineClient.prototype.getQueriesDataFromServer = function (queryDefs, options) {
      return this._makeRequestToServer('/getQueriesData', queryDefs, options);
    };

    QueryEngineClient.prototype.getQueriesHtmlFromServer = function (queryDefs, options) {
      return this._makeRequestToServer('/getQueriesHtml', queryDefs, options);
    };

    QueryEngineClient.prototype.gremlin = function (options) {
      if (!options.timeout) {
        options.timeout = 1 * 60 * 1000; // 1 minute
      }
      const config = { params: { options } };
      return $http.post(chrome.getBasePath() + '/gremlin', config);
    };

    QueryEngineClient.prototype.gremlinClearCache = function () {
      const options = { method: 'GET', headers: { 'Accept': 'application/json' } };
      return $http.post(chrome.getBasePath() + '/gremlin/clearCache', { params: { options } });
    };

    QueryEngineClient.prototype.gremlinReloadOntologyModel = function () {
      const options = { method: 'GET', headers: { 'Accept': 'application/json' } };
      return $http.post(chrome.getBasePath() + '/gremlin/reloadOntologyModel', { params: { options } });
    };

    QueryEngineClient.prototype.gremlinPing = function (url) {
      return $http.post(chrome.getBasePath() + '/gremlin/ping', { url: url });
    };

    QueryEngineClient.prototype.schemaQuery = function (options) {
      return $http.post(chrome.getBasePath() + '/schemaQuery', options);
    };

    QueryEngineClient.prototype.schemaUpdate = function (options) {
      return $http.post(chrome.getBasePath() + '/schemaUpdate', options);
    };

    QueryEngineClient.prototype.clearCache = function (service) {
    // kibi: if service is passed and service is different from 'query','template' and 'script' do nothing
      if (service) {
        if (!(service.type === 'query' || service.type === 'template' || service.type === 'script')) {
          return Promise.resolve();
        }
      }
      // kibi: end
      return $http.get(chrome.getBasePath() + '/clearCache');
    };

    return new QueryEngineClient();
  });
