import { uiModules } from 'ui/modules';

uiModules.get('kibana').directive('sirenValidateCustomDateMath', function (es, $timeout) {
  return {
    restrict: 'A',
    require: 'ngModel',
    link: function ($scope, elem, attr, ngModel) {
      ngModel.$parsers.unshift(sirenValidateCustomDateMath);
      ngModel.$formatters.unshift(sirenValidateCustomDateMath);

      $scope.$watch(attr.ngModel, (value) => {
        ngModel.$modelValue = value;
      });

      // function sends validation status to directive filterEditor
      // where we build request and disable/enable 'Save' button
      // if validation fails/passes
      function sendValidationStatus() {
        if (ngModel.$valid) {
          $scope.$emit('siren:filterEditor:checkValidation', true);
        } else {
          $scope.$emit('siren:filterEditor:checkValidation', false);
        };
      };

      function sirenValidateCustomDateMath(input) {
        if (input == null || input === '') {
          $timeout(() => {
            ngModel.$setValidity('sirenValidateCustomDateMath', true);
            sendValidationStatus();
          }, 500);
          return null;
        }

        const request = {
          index: attr.indexPattern,
          body: { query: { match_phrase: {} } }
        };
        request.body.query.match_phrase[attr.field] = input;

        es.search(request)
          .then(() => {
            ngModel.$setValidity('sirenValidateCustomDateMath', true);
            sendValidationStatus();
            return;
          })
          .catch(() => {
            ngModel.$setValidity('sirenValidateCustomDateMath', false);
            sendValidationStatus();
            return;
          });
        return input;
      }
    }
  };
});
